var _gotPersons


function GetPersons(){
	_gotPersons=[]
	var l=GetPersonList()
	for(var t=0;t<l.length;++t){
		_gotPersons[t] = new PersonState(l[t])
	}
}

function RestorePersons(){
	ChangeMap(GetCurrentMap())
	for(var t=0;t<_gotPersons.length;++t){
		_gotPersons[t].apply()
	}
}


const old_CreatePerson=CreatePerson;

CreatePerson = function(name,spriteset,destroy_with_map){
	old_CreatePerson(name,"Border.rss",destroy_with_map)
	SetPersonSpriteset(name,LoadSpriteset(spriteset))
	SetPersonValue(name,"spriteset","spritesets/"+spriteset)
	SetPersonValue(name,"cmd_queue","var cmd_queue=[];var cmd_immediate=[]")
	SetPersonValue(name,"mov_queue","var mov_queue=[];var mov_wflag=[]")
}

const old_SetPersonSpriteset=SetPersonSpriteset;

SetPersonSpriteset = function(name,spriteset){
	SetPersonValue(name,"spriteset",spriteset.filename)
	old_SetPersonSpriteset(name,spriteset)
}


function PersonState(name){
	this.name = name;
	this.x = GetPersonX(name);
	this.y = GetPersonY(name);
	this.layer = GetPersonLayer(name);
	this.direction = GetPersonDirection(name);
	this.frame = GetPersonFrame(name);
	this.speed_x = GetPersonSpeedX(name);
	this.speed_y = GetPersonSpeedY(name);
	this.frameRevert = GetPersonFrameRevert(name);
	this.spriteset = GetPersonValue(name,"spriteset")
	if(this.spriteset=="") this.spriteset=GetPersonSpriteset(name).filename
	SetPersonValue(name,"spriteset",this.spriteset)
	this.angle = GetPersonAngle(name);
	this.mask = GetPersonMask(name);
	this.visible = IsPersonVisible(name);
	this.data = GetPersonData(name);
	this.command_queue = GetPersonCommandQueue(name);
	this.move_queue = GetPersonMovQueue(name);
	this.ignoringPersonObstructions = IsIgnoringPersonObstructions(name);
	this.ignoringTileObstructions = IsIgnoringTileObstructions(name);
	this.ignore_list = GetPersonIgnoreList(name);
}

PersonState.prototype.apply = function(){
	var spriteset=Right(this.spriteset,this.spriteset.length-"spritesets/".length)
	if(!IsPersonExist(this.name)) CreatePerson(this.name,spriteset,true)
	else SetPersonSpriteset(this.name,LoadSpriteset(spriteset))
	SetPersonX(this.name,this.x)
	SetPersonY(this.name,this.y)
	SetPersonLayer(this.name,this.layer)
	SetPersonDirection(this.name,this.direction)
	SetPersonFrame(this.name,this.frame)
	SetPersonSpeedXY(this.name,this.speed_x,this.speed_y)
	SetPersonFrameRevert(this.name,this.frameRevert)
	SetPersonAngle(this.name,this.angle)
	SetPersonMask(this.name,this.mask)
	SetPersonVisible(this.name,this.visible)
	SetPersonData(this.name,this.data)
	SetPersonCommandQueue(this.name,this.command_queue)
	SetPersonMovQueue(this.name,this.move_queue)
	IgnorePersonObstructions(this.name,this.ignoringPersonObstructions)
	IgnoreTileObstructions(this.name,this.ignoringTileObstructions)
	SetPersonIgnoreList(this.name,this.ignore_list)
	
	if(Left(this.name,4)=="gras")
		for(var t=this.frame;t<this.data.num_frames;++t) SetDelayScript((t-this.frame)*10,"SetPersonFrame('"+this.name+"',"+t+")")
	if(Left(this.name,5)=="wolke")
		for(var t=this.frame;t<this.data.num_frames;++t) SetDelayScript((t-this.frame)*8,"SetPersonFrame('"+this.name+"',"+t+")")
}

//Command-Queue-Getter///////////////////////////////
const old_QueuePersonCommand=QueuePersonCommand;
const old_QueuePersonScript=QueuePersonScript;
const old_ClearPersonCommands=ClearPersonCommands;

QueuePersonCommand = function(name,command,immediate){
	old_QueuePersonCommand(name,command,immediate)
	_addCommand(name,command,immediate)
	old_QueuePersonScript(name,"_removeCommand()",true)
}

QueuePersonScript = function(name,script,immediate){
	old_QueuePersonScript(name,script,immediate)
	_addCommand(name,script,immediate)
	old_QueuePersonScript(name,"_removeCommand()",true)
}

ClearPersonCommands = function(name){
	old_ClearPersonCommands(name)
	SetPersonValue(name,"cmd_queue","var cmd_queue=[]")
	SetPersonValue(name,"mov_queue","var mov_queue=[]")
}

function _addCommand(name,command,immediate){
	eval(GetPersonValue(name,"cmd_queue"))
	if(typeof(cmd_queue)=="undefined") var cmd_queue = [];
	if(typeof(cmd_immediate)=="undefined") var cmd_immediate = [];
	cmd_queue.push(command)
	cmd_immediate.push(immediate)
	SetPersonValue(name,"cmd_queue","var cmd_queue="+cmd_queue.toSource()+";var cmd_immediate="+cmd_immediate.toSource())
}

function _removeCommand(name){
	if(name==undefined) name=GetCurrentPerson()
	eval(GetPersonValue(name,"cmd_queue"))
	if(typeof(cmd_queue)=="undefined") var cmd_queue = [];
	if(typeof(cmd_immediate)=="undefined") var cmd_immediate = [];
	cmd_queue.shift()
	cmd_immediate.shift()
	SetPersonValue(name,"cmd_queue","var cmd_queue="+cmd_queue.toSource()+";var cmd_immediate="+cmd_immediate.toSource())
}

function GetPersonCommandQueue(name){
	if(!IsPersonExist(name)) return []
	eval(GetPersonValue(name,"cmd_queue"))
	if(typeof(cmd_queue)=="undefined") var cmd_queue = [];
	if(typeof(cmd_immediate)=="undefined") var cmd_immediate = [];
	var cmd = []
	for(var t=0;t<cmd_queue.length;t++) cmd[t] = {cmd: cmd_queue[t], imd: cmd_immediate[t]}
	return cmd
}

function SetPersonCommandQueue(name,cmd_queue){
	ClearPersonCommands(name)
	for(var t=0;t<cmd_queue.length;t++){
		if(typeof(cmd_queue[t].cmd)=="number") QueuePersonCommand(name,cmd_queue[t].cmd,cmd_queue[t].imd)
		else QueuePersonScript(name,cmd_queue[t].cmd,cmd_queue[t].imd)
	}
}

//////////////////////////////////////////////////////

function Move(name,dir,wait_flag){
	dir.replace("north","o")
	dir.replace("south","u")
	dir.replace("west","l")
	dir.replace("east","r")
	eval(GetPersonValue(name,"mov_queue"))
	if(typeof(mov_queue)=="undefined") var mov_queue=[];
	if(typeof(mov_wflag)=="undefined") var mov_wflag=[];
	mov_queue.push(dir)
	mov_wflag.push(wait_flag)
	SetPersonValue(name,"mov_queue","var mov_queue="+mov_queue.toSource()+";var mov_wflag="+mov_wflag.toSource())
}

function SetPersonPath(name,path,wait_flag){//Beta
	for(var t=0;t<path.length;++t){
		Move(name,path[t],wait_flag)
	}
}

function GetPersonMovQueue(name){
	if(!IsPersonExist(name)) return []
	eval(GetPersonValue(name,"mov_queue"))
	if(typeof(mov_queue)=="undefined") var mov_queue=[];
	if(typeof(mov_wflag)=="undefined") var mov_wflag=[];
	var cmd=[]
	for(var t=0;t<mov_queue.length;t++) cmd[t] = {dir: mov_queue[t], wfl: mov_wflag[t]}
	return cmd
}

function SetPersonMovQueue(name,mov_queue){
	var queue=[]
	var wflag=[]
	for(var t=0;t<mov_queue.length;t++){
		queue[t]=mov_queue[t].dir
		wflag[t]=mov_queue[t].dir
	}
	SetPersonValue(name,"mov_queue","var mov_queue="+queue.toSource()+";var mov_wflag="+wflag.toSource())
}

function UpdateMovQueue(){
	var l=GetPersonList()
	for(var t=0;t<l.length;++t){
		if(!IsPersonExist(l[t])) continue;
		delete mov_queue;
		if(GetPersonCommandQueue(l[t]).length==0){
			eval(GetPersonValue(l[t],"mov_queue"))
			if(typeof(mov_queue)=="undefined") var mov_queue=[];
			if(mov_queue.length>0){
				ClearPersonCommands(l[t])
				var co=mov_queue[mov_queue.length-1]
				ApplyMovement(mov_queue.shift(),l[t],mov_wflag.shift())
				old_QueuePersonCommand(l[t],COMMAND_WAIT,false)
				SetPersonValue(l[t],"mov_queue","var mov_queue="+mov_queue.toSource()+";var mov_wflag="+mov_wflag.toSource())
			}
		}
	}
}

function ActualizeTilepos(){
	var l=GetPersonList()
	for(var t=0;t<l.length;++t){
		if(!IsPersonExist(l[t])) continue
		var x=GetPersonX(l[t])
		var y=GetPersonY(l[t])
		var tx=(x-7)/16
		var ty=(y-7)/16
		if(tx%1==0) SetPersonValue(l[t],"TileX",tx)
		if(ty%1==0) SetPersonValue(l[t],"TileY",ty)
	}
}

function GetPersonTileX(name){
	if(!IsPersonExist(name)) return -1337
	return GetPersonValue(name,"TileX")
}

function GetPersonTileY(name){
	if(!IsPersonExist(name)) return -1337
	return GetPersonValue(name,"TileY")
}

function IsPersonExist(name)
{
var list = GetPersonList()
var returner = false
var _t = 0
while(_t < list.length)
	{

		if(list[_t] == name)
		{
			return true
		}
		++_t
	}
return false
}



function StringToFacing(Person, string)
{
switch(string)
{
case "north":
QueuePersonCommand(Person, COMMAND_FACE_NORTH, true)
break;

case "northeast":
QueuePersonCommand(Person, COMMAND_FACE_NORTHEAST, true)
break;

case "east":
QueuePersonCommand(Person, COMMAND_FACE_EAST, true)
break;

case "southeast":
QueuePersonCommand(Person, COMMAND_FACE_SOUTHEAST, true)
break;

case "south":
QueuePersonCommand(Person, COMMAND_FACE_SOUTH, true)
break;

case "southwest":
QueuePersonCommand(Person, COMMAND_FACE_SOUTHWEST, true)
break;

case "west":
QueuePersonCommand(Person, COMMAND_FACE_WEST, true)
break;

case "northwest":
QueuePersonCommand(Person, COMMAND_FACE_NORTHWEST, true)
break;
}
}


function GetPersonDirectionNum(person){
	var dir=GetPersonSpriteset(person).directions
	var t=dir.length;
	var d=GetPersonDirection(person)
	while(--t>dir.length) if(dir[t].name==d) return t
	return 0
}

/*
var PersonList = new Array()
var PersonsX = new Array()
var PersonsY = new Array()
var PersonsFrame = new Array()
var PersonsFacing = new Array()
var PersonTyp = new Array()
var PersonIgnoreList = new Array()

function GetPersons()
{
PersonList = new Array()
PersonsX = new Array()
PersonsY = new Array()
PersonsFrame = new Array()
PersonsFacing = new Array()
PersonTyp = new Array()
PersonIgnoreList = new Array()
PersonList = GetPersonList()
var t = 0
while(t < PersonList.length)
{
PersonsX[t] = GetPersonX(PersonList[t])
PersonsY[t] = GetPersonY(PersonList[t])
PersonsFrame[t] = GetPersonFrame(PersonList[t])
PersonsFacing[t] = GetPersonDirection(PersonList[t])
PersonTyp[t] = "person"
PersonIgnoreList[t] = GetPersonIgnoreList(PersonList[t])


if(GetPersonSpriteset(PersonList[t]).filename == "spritesets/Verschiedenes/Gras.rss")
{
PersonTyp[t] = "gras"
}

if(GetPersonSpriteset(PersonList[t]).filename == "spritesets/Verschiedenes/Wolke.rss")
{
PersonTyp[t] = "wolke"
}

++t
}
}

function RestorePersons(commands)
{
var t = 0
while(t < PersonList.length)
{

if(IsPersonExist(PersonList[t]) == false)
{
if(PersonTyp[t] == "gras")
{
CreatePerson(PersonList[t], "Verschiedenes/Gras.rss", true)
SetPersonScript(PersonList[t], SCRIPT_COMMAND_GENERATOR, "grasc()")
for(var i=PersonsFrame[t];i<4;++i) SetDelayScript(10*(i-PersonsFrame[t]+1),"SetPersonFrame('"+PersonList[t]+"',"+i+")")
}

if(PersonTyp[t] == "wolke")
{
CreatePerson(PersonList[t], "Verschiedenes/Wolke.rss", true)
SetPersonScript(PersonList[t], SCRIPT_COMMAND_GENERATOR, "wolkec()")
}
}

SetPersonX(PersonList[t], PersonsX[t])
SetPersonY(PersonList[t], PersonsY[t])
SetPersonFrame(PersonList[t], PersonsFrame[t])
SetPersonIgnoreList(PersonList[t],PersonIgnoreList[t])
StringToFacing(PersonList[t], PersonsFacing[t])
++t
}
}
*/



